varying vec2 texture_coordinate;
uniform sampler2D source;
uniform vec2 blurvector;

// Linear-weight blur: (1,2,3,4,25,4,3,2,1)
void main() {
	vec3 accum;
	int i = 0;

	for(i=-4 ; i<=4; i++) {
		vec2 d = blurvector*(float(i)/4.0);
		float w = 5.0-abs(float(i));
		if(i == 0)
			w = 15.0;
			
		accum += texture2D(source, texture_coordinate + d, length(d)*256.0).rgb * w;
	}
	
	gl_FragColor = vec4(accum/30.0, 1) ;
}
